#include "driver.h"
#include "math.h"
#include "gpdef.h"
#include "gpstdio.h"
#include "gpstdlib.h"
#include "gpgraphic.h"
#include "gpfont.h"
#include "gpmem.h"
#include "gp32_mame.h"

#define FPS_DISPLAY 1

/* Converts 8bit rgb values to a GP32 palette value */
#define RGBA(R,G,B,A) (((R&0xF8)<<8)|((G&0xF8)<<3)|((B&0xF8)>>2)|A)
#define WAITKEY while(!osd_key_pressed(OSD_KEY_PAUSE)) { Delay(100); osd_poll_joystick();}Delay(200);osd_poll_joystick();


struct osd_bitmap *scrbitmap;
unsigned char current_palette[256][3];
unsigned char dirtycolor[256];
int dirtypalette;

/* Timing variables */
unsigned int prev;
extern int frameskip;
int gp32_frameskip=2;
int gp32_frameskip_auto=1;

/* GP32 Graphic Display Variables */
int game_width;
int game_height;
int gp32_xoffset;
int gp32_yoffset;
int gp32_xscreen;
int gp32_yscreen;
int gp32_width;
int gp32_height;
int visible_game_width;
int visible_game_height;
int visible_game_width_offset;
int visible_game_height_offset;
int gp32_rotate=0;
int gp32_triple_buffer=0;
int gp32_gamma=10;
int gp32_new_gfx_core=1;
int stretch=0; /* 0= None, 1=Normal, 2=Mix */
int gp32_fps_display=0; /* 0=On, 1=Off */
int old_counter=0;
int skip_h=0;
int skip_v=0;

/* GP32 related stuff */
GPDRAWSURFACE gpDraw[4];	/* Video Buffers */
int nflip;			/* Video buffer index */

unsigned long *gpPalette=(unsigned long *)0x14A00400; /* Pointer to Palette */ 
unsigned char* gpPicture=(unsigned char *)0x0C7B4000; /* Pointer to Video */


/* GP32 Video Init */
void gp32_video_init(void) {

	int i=0;

	/* GP32 Video Init */
	GpGraphicModeSet(8,0);  /* 320x240, 256 colors */

	for( i=0; i<4; i++ ) {
		GpLcdSurfaceGet( &gpDraw[i],i );
		GpRectFill( NULL, &gpDraw[i],0,0,gpDraw[i].buf_w,gpDraw[i].buf_h,0x0 );
	}
	nflip=0;
	GpSurfaceSet( &gpDraw[nflip] );
	GpLcdEnable();
	GpSurfaceFlip( &gpDraw[nflip] );

	
}

void gp32_mame_palette(void) {

	GP_PALETTEENTRY colorgp;
	int i;
	
	/* Color #0 is black */
	colorgp = RGBA(0,0,0,0);
	for (i=0;i<256;i++)
		gpPalette[i]=colorgp;
	
	/* Color #1 is white */
	colorgp = RGBA(255,255,255,0);
	gpPalette[1]=colorgp;
}

/* Adjust Display: New Gfx Core */
void gp32_adjust_display(void) {

	/* Image not rotated */
	if (!gp32_rotate) {

		gp32_rotate=0;
		gp32_xoffset=0;
		gp32_yoffset=0;
		gp32_xscreen=0;
		gp32_yscreen=0;
		gp32_width=320;
		gp32_height=240;
		skip_h=0;
		skip_v=0;

                /* GP32 screen has sideways screen memory, not top-to-bottom
                   Therefore we compare the width of the GP32 screen to the
                   height of the game screen */
		if (visible_game_height>320)
		{
			if (stretch)
			{
				skip_v=320/(visible_game_height-320);
				/* For large resolution games scale the resolution by half
				   This is useful for the mcr3.c games like Discs of Tron, etc */
				if (visible_game_height > 400)
				{
					skip_v = 1;
					gp32_xscreen = (320 - (visible_game_height / (1 << skip_v))) / 2;
					if (gp32_xscreen < 0) gp32_xscreen = 0;
					gp32_width = (visible_game_height / (1 << skip_v));
					if (gp32_width > 320) gp32_width = 320;
				}
			}
			else
				gp32_xoffset = (visible_game_height-320) / 2;
		}
		else {
			gp32_width = visible_game_height;
			gp32_xscreen = (320-visible_game_height) / 2;
		}
		gp32_xoffset+= visible_game_height_offset;
		
		if (visible_game_width>240)
		{
			if (stretch)
			{
				skip_h=240/(visible_game_width-240);
				/* For large resolution games scale the resolution by half
				   This is useful for the mcr3.c games like Discs of Tron, etc */
				if (visible_game_width > 300)
				{
					skip_h = 1;
					gp32_yscreen = (240 - (visible_game_width / (1 << skip_h))) / 2;
					if (gp32_yscreen < 0) gp32_yscreen = 0;
					gp32_height = (visible_game_width / (1 << skip_h));
					if (gp32_height > 240) gp32_height = 240;
				}
			}
			else
				gp32_yoffset = (visible_game_width-240) / 2;
		}
		else {
			gp32_height = visible_game_width;		
			gp32_yscreen = (240-visible_game_width) / 2;
		}
		gp32_yoffset+= visible_game_width_offset;

	} else {
		/* Image has to be rotated */	
		gp32_rotate=1;
		gp32_xoffset=0;
		gp32_yoffset=0;
		gp32_xscreen=0;
		gp32_yscreen=0;
		gp32_width=240;
		gp32_height=320;
		skip_h=0;
		skip_v=0;
		
		if (visible_game_height>240)
/* start new */
                        if (stretch)
                        {
                                skip_v=240/(visible_game_height-240);
                                /* For large resolution games scale the resolution by half
                                   This is useful for the mcr3.c games like Discs of Tron, etc */
                                if (visible_game_height > 300)
                                {
					skip_v=1;
                                        gp32_xscreen = (240 - (visible_game_height / (1 << skip_v))) / 2;
					if (gp32_xscreen < 0) gp32_xscreen = 0;
                                        gp32_width = (visible_game_height / (1 << skip_v));
					if (gp32_width > 240) gp32_xscreen = 240;
                                }
                        }
                        else
                                gp32_xoffset = (visible_game_height-240) / 2;
/* end new */
		else {
			gp32_width = visible_game_height;
			gp32_xscreen = (240-visible_game_height) / 2;
		}
		gp32_xoffset+= visible_game_height_offset;
		
		if (visible_game_width>320) 
/* start new */
			if (stretch)
			{
				skip_h=320/(visible_game_width-320);
				/* For large resolution games scale the resolution by half
				   This is useful for the mcr3.c games like Discs of Tron, etc */
				if (visible_game_width > 400)
				{
					skip_h = 1;
					gp32_yscreen = (320 - (visible_game_width / (1 << skip_h))) / 2;
					if (gp32_yscreen < 0) gp32_yscreen = 0;
					gp32_height = (visible_game_width / (1 << skip_h));
					if (gp32_height > 320) gp32_height = 320;
				}
			}
			else
				gp32_yoffset = (visible_game_width-320) / 2;
/* end new */
		else {
			gp32_height = visible_game_width;
			gp32_yscreen = (320-visible_game_width) / 2;
		}
		gp32_yoffset+= visible_game_width_offset;
	}
}

/* Adjust Display: Old Gfx Core */
void gp32_adjust_display_old(void) {

	/* Image not rotated */
	if (gp32_rotate==0) {

		gp32_rotate=0;
		gp32_xoffset=0;
		gp32_yoffset=0;
		gp32_xscreen=0;
		gp32_yscreen=0;
		gp32_width=320;
		gp32_height=240;
		skip_h=0;
		skip_v=0;
		
		if (visible_game_width>320)
		{	
			if (stretch)
			{
				skip_h=320/(visible_game_width-320);
				/* For large resolution games scale the resolution by half
				   This is useful for the mcr3.c games like Discs of Tron, etc */
				if (visible_game_width > 400)
				{
					skip_h = 1;
					gp32_xscreen = (320 - (visible_game_width / (1 << skip_h))) / 2;
					if (gp32_xscreen < 0) gp32_xscreen = 0;
					gp32_width = (visible_game_width / (1 << skip_h));
					if (gp32_width > 320) gp32_width = 320;
				}
			}
			else
				gp32_xoffset = (visible_game_width-320) / 2;
		}
		else {
			gp32_width = visible_game_width;
			gp32_xscreen = (320-visible_game_width) / 2;
		}
		gp32_xoffset+= visible_game_width_offset;
		
		if (visible_game_height>240)
		{
			if (stretch)
				skip_v=240/((visible_game_height > 480 ? 480 : visible_game_height)-240);
				/* For large resolution games scale the resolution by half
				   This is useful for the mcr3.c games like Discs of Tron, etc */
				if (visible_game_height > 300)
				{
					skip_v = 1;
					gp32_yscreen = (240 - (visible_game_height / (1 << skip_v))) / 2;
					if (gp32_yscreen < 0) gp32_yscreen = 0;
					gp32_height = (visible_game_height / (1 << skip_v));
					if (gp32_height > 240) gp32_height = 240;
				}
			else
				gp32_yoffset = (visible_game_height-240) / 2 ;
		}
		else {
			gp32_height = visible_game_height;
			gp32_yscreen = (240-visible_game_height) / 2;
		}
		gp32_yoffset+= visible_game_height_offset;


	} else {
		/* Image has to be rotated */	
		gp32_rotate=1;
		gp32_xoffset=0;
		gp32_yoffset=0;
		gp32_xscreen=0;
		gp32_yscreen=0;
		gp32_width=240;
		gp32_height=320;
		
		if (visible_game_width>240)
/**/
			if (stretch)
			{
				skip_h=240/(visible_game_width-240);
				/* For large resolution games scale the resolution by half
				   This is useful for the mcr3.c games like Discs of Tron, etc */
				if (visible_game_width > 400)
				{
					skip_h = 1;
					gp32_xscreen = (240 - (visible_game_width / (1 << skip_h))) / 2;
					if (gp32_xscreen < 0) gp32_xscreen = 0;
					gp32_width = (visible_game_width / (1 << skip_h));
					if (gp32_width > 240) gp32_width = 240;
				}
			}
			else
				gp32_xoffset = (visible_game_width-240) / 2 ;
/**/
		else {
			gp32_width = visible_game_width;
			gp32_xscreen = (240-visible_game_width) / 2;
		}
		gp32_xoffset+= visible_game_width_offset;

		if (visible_game_height>320) 
		{
			if (stretch)
				skip_v=320/((visible_game_height > 512 ? 512 : visible_game_height)-320);
				/* For large resolution games scale the resolution by half
				   This is useful for the mcr3.c games like Discs of Tron, etc */
				if (visible_game_height > 400)
				{
					skip_v = 1;
					gp32_yscreen = (320 - (visible_game_height / (1 << skip_v))) / 2;
					if (gp32_yscreen < 0) gp32_yscreen = 0;
					gp32_height = (visible_game_height / (1 << skip_v));
					if (gp32_height > 320) gp32_height = 320;
				}
			else
				gp32_yoffset = (visible_game_height-320) / 2;
		}
		else {
			gp32_height = visible_game_height;
			gp32_yscreen = (320-visible_game_height) / 2;
		}
		gp32_yoffset+= visible_game_height_offset;
	}
}

/* Game List Text Out */
void gp32_gamelist_text_out(int x, int y, char *eltexto) {
	char texto[33];
	gm_strncpy(texto,eltexto,32);
	if (texto[0]!='-')
		GpTextOut( NULL, &gpDraw[nflip],x+1,y+1,texto, 0 /* 0xff */ );
	GpTextOut( NULL, &gpDraw[nflip],x,y,texto, 100 /* 0xff */ );
}

/* Variadic functions guide found at http://www.unixpapa.com/incnote/variadic.html */
void gp32_gamelist_text_out_fmt(int x, int y, char* fmt, ...)
{
	char strOut[128];
	va_list marker;
	
	va_start(marker, fmt);
	vsprintf(strOut, fmt, marker);
	va_end(marker);	

	gp32_gamelist_text_out(x, y, strOut);
}

/* Debug information function*/
void gp32_text_out(int x, int y, char *texto) {
	GpTextOut( NULL, &gpDraw[nflip],x,y,texto, 0x01 /* 0xff */ );
}

/* Debug information function*/
void gp32_text_out_int(int x, int y, int entero) {
	char texto[20];
	gm_sprintf(texto,"%d\n",entero);
	GpTextOut( NULL, &gpDraw[nflip],x+1,y+1,texto, 0x00 /* 0xff */ );
	GpTextOut( NULL, &gpDraw[nflip],x,y,texto, 0x01 /* 0xff */ );

}
/* Debug information function*/
void gp32_text_out_float(int x, int y, float entero) {
	char texto[20];
	gm_sprintf(texto,"%2.2f\n",entero);
	GpTextOut( NULL, &gpDraw[nflip],x+1,y+1,texto, 0x00 /* 0xff */ );
	GpTextOut( NULL, &gpDraw[nflip],x,y,texto, 0x01 /* 0xff */ );
}

static int logrow=0;

/* Set Debug Log start at row 0 */
void gp32_gamelist_zero(void) {
	logrow=0;
}

/* Pause Text Message */
void gp32_text_pause(void) {
	if (gp32_triple_buffer) {
		nflip++;
		nflip&=3;
	}
	GpTextOut( NULL, &gpDraw[nflip],141,111,"PAUSE\0", 0x00);
	GpTextOut( NULL, &gpDraw[nflip],140,110,"PAUSE\0", 0x01);
}

/* Debug Log information funcion */
void gp32_text_log(char *texto) {
	if (!logrow)
		GpRectFill( NULL, &gpDraw[nflip],0,0,gpDraw[nflip].buf_w,gpDraw[nflip].buf_h,0x0 );
		
	gp32_text_out(0,logrow,texto);
	logrow+=15;
	if(logrow>239) logrow=0;
}

/* Debug Log information funcion */
void gp32_text_log_int(int entero) {
	if (!logrow)
		GpRectFill( NULL, &gpDraw[nflip],0,0,gpDraw[nflip].buf_w,gpDraw[nflip].buf_h,0x0 );
	
	gp32_text_out_int(0,logrow,entero);
	logrow+=15;
	if(logrow>239) logrow=0;
}

/* Variadic functions guide found at http://www.unixpapa.com/incnote/variadic.html */
void gp32_text_log_fmt(char* fmt, ...)
{
	char strOut[128];
	va_list marker;
	
	va_start(marker, fmt);
	vsprintf(strOut, fmt, marker);
	va_end(marker);	

	gp32_text_log(strOut);
}

/* Create a bitmap. Also calls osd_clearbitmap() to appropriately initialize */
/* it to the background color. */
/* VERY IMPORTANT: the function must allocate also a "safety area" 8 pixels wide all */
/* around the bitmap. This is required because, for performance reasons, some graphic */
/* routines don't clip at boundaries of the bitmap. */
struct osd_bitmap *osd_new_bitmap(int width,int height,int depth)       /* ASG 980209 */
{
	struct osd_bitmap *bitmap;
	char sMemMsg[60];
	
	if (Machine->orientation & ORIENTATION_SWAP_XY)
	{
		int temp;

		temp = width;
		width = height;
		height = temp;
	}
	

	if ((bitmap = gm_zi_malloc(sizeof(struct osd_bitmap))) != 0)
	{
		int i,rowlen,rdwidth;
		unsigned char *bm;
		int safety;


		if (width > 32) safety = 8;
		else safety = 0;        /* don't create the safety area for GfxElement bitmaps */

		if (depth != 8 && depth != 16) depth = 8;

		bitmap->depth = depth;
		bitmap->width = width;
		bitmap->height = height;

		rdwidth = (width + 7) & ~7;     /* round width to a quadword */
		if (depth == 16)
			rowlen = 2 * (rdwidth + 2 * safety) * sizeof(unsigned char);
		else
			rowlen =     (rdwidth + 2 * safety) * sizeof(unsigned char);

		if (!(bm = gm_zi_malloc((height + 2 * safety) * rowlen)))
		{
			gp32_text_log("osd_new_bitmap(): Out of Memory");
			gm_sprintf(sMemMsg, "Want: %d Avail: %d", (height + 2 * safety) * rowlen, gm_availablesize()); 
			gp32_text_log(sMemMsg);
			WAITKEY
			gm_free(bitmap);
			return 0;
		}

		if (!(bitmap->line = gm_malloc(height * sizeof(unsigned char *))))
		{
/*
			gp32_text_log("osd_new_bitmap(): Out of Memory");
*/
			gm_free(bm);
			gm_free(bitmap);
			return 0;
		}

		for (i = 0;i < height;i++)
			bitmap->line[i] = &bm[(i + safety) * rowlen + safety];

		bitmap->_private = bm;

		/* osd_clearbitmap(bitmap);  Already being set to ZERO with gm_zi_malloc() */
	}
	
	if(!bitmap)
		gp32_text_log("osd_new_bitmap(): Out of Memory");

	return bitmap;
}



/* set the bitmap to black */
void osd_clearbitmap(struct osd_bitmap *bitmap)
{
	int i;
	for (i = 0;i < bitmap->height;i++)
		asm_memset(bitmap->line[i],0,bitmap->width);
}



void osd_free_bitmap(struct osd_bitmap *bitmap)
{
	if (bitmap)
	{
		gm_free(bitmap->line);
		gm_free(bitmap->_private);
		gm_free(bitmap);
	}
}


/* Create a display screen, or window, large enough to accomodate a bitmap */
/* of the given dimensions. Attributes are the ones defined in driver.h. */
/* Return a osd_bitmap pointer or 0 in case of error. */
struct osd_bitmap *osd_create_display(int width,int height,int attributes, int visible_width, int visible_height,
					                  int visible_width_offset, int visible_height_offset )
{
	int     i;

	game_width = width;
	game_height = height;

	if (attributes & VIDEO_TYPE_VECTOR) {
		visible_game_width = width;
		visible_game_height = height;
		visible_game_width_offset = 0;
		visible_game_height_offset = 0;
	} else {
		visible_game_width = visible_width;
		visible_game_height = visible_height;
		visible_game_width_offset = visible_width_offset;
		visible_game_height_offset = visible_height_offset;
	}

	/* Offset alignment */
	{
		int alignment;
		alignment= visible_game_width_offset % 8;
		if (alignment) {
			visible_game_width_offset-=alignment; /* visible_game_width_offset must be multiple of 8 */
			visible_game_width+=alignment;
			visible_game_width+=(8-alignment); /* visible_game_width must be multiple of 8 */
		}
		alignment= visible_game_height_offset % 8;
		if (alignment) {
			visible_game_height_offset-=alignment; /* visible_game_height_offset must be multiple of 8 */
			visible_game_height+=alignment;
			visible_game_height+=(8-alignment); /* visible_game_height must be multiple of 8 */
		}
	}

	if (Machine->orientation & ORIENTATION_SWAP_XY)
	{
		int temp;

		temp = game_width;
		game_width = game_height;
		game_height = temp;
		temp = visible_game_width;
		visible_game_width = visible_game_height;
		visible_game_height = temp;
		temp = visible_game_width_offset;
		visible_game_width_offset = visible_game_height_offset;
		visible_game_height_offset = temp;
	}

	if (Machine->orientation & ORIENTATION_FLIP_X)    /* offset by other side */
		visible_game_width_offset = game_width-visible_game_width-visible_game_width_offset;

	if (Machine->orientation & ORIENTATION_FLIP_Y)
		visible_game_height_offset = game_height-visible_game_height-visible_game_height_offset;
	
	if (gp32_new_gfx_core)
		gp32_adjust_display();
	else
		gp32_adjust_display_old();

	scrbitmap = osd_new_bitmap(width,height,8);
	if (!scrbitmap) return 0;

	for (i = 0;i < 256;i++)
	{
		dirtycolor[i] = 1;
	}
	dirtypalette = 1;

    	return scrbitmap;
}


/* shut up the display */
void osd_close_display(void)
{
	if (scrbitmap)
	{
		osd_free_bitmap(scrbitmap);
		scrbitmap = NULL;
	}
}


/* palette is an array of 'totalcolors' R,G,B triplets. The function returns */
/* in *pens the pen values corresponding to the requested colors. */
/* If 'totalcolors' is 32768, 'palette' is ignored and the *pens array is filled */
/* with pen values corresponding to a 5-5-5 15-bit palette */
void osd_allocate_colors(unsigned int totalcolors,const unsigned char *palette,unsigned short *pens)
{

	int i;

	/* initialize the palette */
	for (i = 0;i < 256;i++)
		current_palette[i][0] = current_palette[i][1] = current_palette[i][2] = 0;

	if (totalcolors >= 255)
	{
		int bestblack,bestwhite;
		int bestblackscore,bestwhitescore;

		for (i = 0;i < totalcolors;i++)
			pens[i] = i;

		bestblack = bestwhite = 0;
		bestblackscore = 3*255*255;
		bestwhitescore = 0;
		for (i = 0;i < totalcolors;i++)
		{
			int r,g,b,score;

			r = palette[3*i];
			g = palette[3*i+1];
			b = palette[3*i+2];
			score = r*r + g*g + b*b;

			if (score < bestblackscore)
			{
				bestblack = i;
				bestblackscore = score;
			}
			if (score > bestwhitescore)
			{
				bestwhite = i;
				bestwhitescore = score;
			}
		}
	}
	else
	{
		/* reserve color 1 for the user interface text */
		current_palette[1][0] = current_palette[1][1] = current_palette[1][2] = 0xff;

		/* fill the palette starting from the end, so we mess up badly written */
		/* drivers which don't go through Machine->pens[] */
		for (i = 0;i < totalcolors;i++)
			pens[i] = 255-i;
	}

	for (i = 0;i < totalcolors;i++)
	{
		current_palette[pens[i]][0] = palette[3*i];
		current_palette[pens[i]][1] = palette[3*i+1];
		current_palette[pens[i]][2] = palette[3*i+2];
	}
}


void osd_modify_pen(int pen,unsigned char red, unsigned char green, unsigned char blue)
{
	if (scrbitmap->depth != 8)
	{
		return;
	}


	if (current_palette[pen][0] != red ||
			current_palette[pen][1] != green ||
			current_palette[pen][2] != blue)
	{
		current_palette[pen][0] = red;
		current_palette[pen][1] = green;
		current_palette[pen][2] = blue;

		dirtycolor[pen] = 1;
		dirtypalette = 1;
	}
}


void osd_get_pen(int pen,unsigned char *red, unsigned char *green, unsigned char *blue)
{
	*red = current_palette[pen][0];
	*green = current_palette[pen][1];
	*blue = current_palette[pen][2];
}


void gp32_clear_screen(void)
{
	int i;
	for(i=0;i<4;i++)
		GpRectFill( NULL, &gpDraw[i],0,0,gpDraw[i].buf_w,gpDraw[i].buf_h,0x0 );
}

/* Wait for correct synchronization */
static __inline void update_timing (void)
{
	unsigned int curr=GpTickCountGet();
	unsigned int previ=prev;
	unsigned int interval=((frameskip+1) * 1012)/(Machine->drv->frames_per_second);
		
	/* now wait until it's time to update the screen */
	if ((curr-previ)<interval) {
		/* Auto-Frameskip -> frameskip-- */
		if (gp32_frameskip_auto && frameskip>0)
			frameskip--;
		while ((curr - previ) < interval) {
			__asm__ __volatile__ ("nop;nop;nop;nop;");
			curr = GpTickCountGet(); /* Get timing */
		}
	} else {
		/* Auto-Frameskip -> frameskip++ */
		if (gp32_frameskip_auto && frameskip<gp32_frameskip)
			frameskip++;
	}
	prev = curr;
}

#ifdef FPS_DISPLAY
unsigned int gp32_fc=0; /* Elapsed frame counter */
unsigned int gp32_fc_v=0; /* Frame Counter to show */
unsigned int gp32_fc_t0; /* Last T0 */
static __inline void frame_counter (void)
{
	unsigned int gp32_fc_t1=GpTickCountGet();
	gp32_fc++;
	if (gp32_fc_t1-gp32_fc_t0>1000) {
		gp32_fc_t0=gp32_fc_t1;
		gp32_fc_v=gp32_fc;
		gp32_fc=0;
	}
	GpRectFill( NULL, &gpDraw[nflip],304,3,16,9,0x0 );
	gp32_text_out_int(304,0,gp32_fc_v);
}
	
#endif	

/* Update GP32 Palette */
static __inline void update_palette (void)
{
	int i;
	int r,g,b;
	char message[41];
	unsigned char *dirty=dirtycolor;
	float gamma = (10 / (float)gp32_gamma);

	for (i = 0;i < 256;i++)
	{
		if (dirty[i])
		{
			dirty[i] = 0;
			
			if (gamma == 10)
				gpPalette[i]=RGBA(current_palette[i][0],current_palette[i][1],current_palette[i][2],0);
			else
				gpPalette[i]=RGBA(
					(int)(255 * pow(current_palette[i][0] / 255.0, gamma)),
					(int)(255 * pow(current_palette[i][1] / 255.0, gamma)),
					(int)(255 * pow(current_palette[i][2] / 255.0, gamma)),
					0
				);
		}
	}
	dirtypalette = 0;
}	

/* Update Display: New Gfx Core - not rotated */
static __inline void update_display (void)
{
	int counter_h=0;
	int counter_v;
	register int *buffer_scr;
	int buffer_scr_offset=(240-gp32_height)>>2;
	register int *buffer_mem = (int *)(scrbitmap->line[gp32_xoffset]+gp32_yoffset);
	int buffer_mem_offset = (((int)(scrbitmap->line[1] - scrbitmap->line[0]))-gp32_height)>>2;
	int x=gp32_width;
	register int y;
	
	if (stretch==2) { /* stretch mix */
		counter_v=(old_counter & 1? 0:1);
		old_counter=counter_v;
	} else 
		counter_v=0; /* stretch skip */

	if(gp32_triple_buffer)
		buffer_scr=(int *)(gpDraw[nflip].o_buffer+gp32_yscreen+(240*gp32_xscreen));
	else
		buffer_scr=(int *)(gpPicture+gp32_yscreen+(240*gp32_xscreen));

	if (stretch==0) {
		do {
#if 0
			/*
			 * Test using asm_memcpy 
			 * Doesn't look like it's any faster...
			 */
			asm_memcpy(buffer_scr, buffer_mem, gp32_height);
			buffer_scr+=buffer_scr_offset+(gp32_height>>2);
			buffer_mem+=buffer_mem_offset+(gp32_height>>2);
#endif 
			y=gp32_height>>2;
			do { 
				*buffer_scr++=*buffer_mem++;
				*buffer_scr++=*buffer_mem++;
				*buffer_scr++=*buffer_mem++;
				*buffer_scr++=*buffer_mem++;
				y-=4;
			} while (y);
			buffer_scr+=buffer_scr_offset;
			buffer_mem+=buffer_mem_offset;
			x--;
		} while (x);
	} else { /* stretch = true */
		register unsigned char *char_buffer_scr;
		register int *buffer_mem_line;

		do {
			char_buffer_scr=(unsigned char *) buffer_scr;
			buffer_mem_line=(int *)buffer_mem;

			y=gp32_height;
			if (stretch==2)
				counter_h=(x & 1? 0:1); /* stretch mix */
			else
				counter_h=0; /* stretch normal*/
			if (!skip_h) {
				y=gp32_height>>2;
				do { 
					*buffer_scr++=*buffer_mem++;
					*buffer_scr++=*buffer_mem++;
					*buffer_scr++=*buffer_mem++;
					*buffer_scr++=*buffer_mem++;
					y-=4;
				} while (y);
			} else { /* skip horizontal lines */

				do {
					if (skip_h==counter_h) {
						counter_h=0;
					} else {
						*(char_buffer_scr++) = (unsigned char)*buffer_mem_line;	
						y--;
						counter_h++;
					}
					
					if (skip_h==counter_h)
						counter_h=0;
					else {
						*(char_buffer_scr++) = (unsigned char)((*buffer_mem_line)>>8);	
						y--;
						counter_h++;
					}

					if (skip_h==counter_h)
						counter_h=0;
					else {
						*(char_buffer_scr++) = (unsigned char)((*buffer_mem_line)>>16);	
						y--;
						counter_h++;
					}

					if (skip_h==counter_h)
						counter_h=0;
					else {
						*(char_buffer_scr++) = (unsigned char)((*buffer_mem_line)>>24);	
						y--;
						counter_h++;
					}

					buffer_mem_line++; 

				} while (y);
				buffer_scr+=gp32_height>>2;
				buffer_mem+=gp32_height>>2;
			}

			buffer_scr+=buffer_scr_offset;	
			buffer_mem+=buffer_mem_offset;

			if (skip_v) {
				counter_v++;
				if (counter_v==skip_v) {
					counter_v=0;
					buffer_mem+=gp32_height>>2;
					buffer_mem+=buffer_mem_offset; 
				}
			}
			
			x--;
		} while (x);
	} /* if (!stretch)*/

}

/* Update Display: New Gfx Core - rotated */
/* static __inline void update_display_rotated (void) */
static void update_display_rotated (void)
{
	int *buffer_scr;
	int buffer_scr_offset=(240-gp32_width)>>2;
	unsigned char *buffer_mem=scrbitmap->line[gp32_width-1+gp32_xoffset]+gp32_yoffset;
	register unsigned char *buffer_mem_line;
	register unsigned char *buffer_mem_line2;
	register unsigned char *buffer_mem_line3;
	register unsigned char *buffer_mem_line4;
	int buffer_mem_offset = (int)(scrbitmap->line[1] - scrbitmap->line[0]);
	int buffer_mem_offset4= buffer_mem_offset * 4;	/* 4 line offset */
	int x,y;
		
	if(gp32_triple_buffer)
		buffer_scr=(int *)(gpDraw[nflip].o_buffer+gp32_xscreen+(240*gp32_yscreen));
	else
		buffer_scr=(int *)(gpPicture+gp32_xscreen+(240*gp32_yscreen));
	x=gp32_height;
	if (stretch==0)
	{
		do {
	/* New Code */
			/* 
			 *	The rotation code has been re-written from MAME GP32 v1.9
			 *	as compiling with gcc4.02 produces problematic results
			 *	Changes:
			 *	* Four buffer_mem_offset pointers instead of the one.
			 *	* Added a 4 line offset.
			 */
			buffer_mem_line=buffer_mem++;
			buffer_mem_line2=buffer_mem_line-buffer_mem_offset;
			buffer_mem_line3=buffer_mem_line2-buffer_mem_offset;
			buffer_mem_line4=buffer_mem_line3-buffer_mem_offset;
			y=gp32_width>>2;
			do {
				*buffer_scr++= (*buffer_mem_line) |
						((*buffer_mem_line2)<<8) |
						((*buffer_mem_line3)<<16) |
						((*buffer_mem_line4)<<24);

				buffer_mem_line-=buffer_mem_offset4;
				buffer_mem_line2-=buffer_mem_offset4;
				buffer_mem_line3-=buffer_mem_offset4;
				buffer_mem_line4-=buffer_mem_offset4;
				*buffer_scr++= (*buffer_mem_line) |
						((*buffer_mem_line2)<<8) |
						((*buffer_mem_line3)<<16) |
						((*buffer_mem_line4)<<24);

				buffer_mem_line-=buffer_mem_offset4;
				buffer_mem_line2-=buffer_mem_offset4;
				buffer_mem_line3-=buffer_mem_offset4;
				buffer_mem_line4-=buffer_mem_offset4;
				*buffer_scr++= (*buffer_mem_line) |
						((*buffer_mem_line2)<<8) |
						((*buffer_mem_line3)<<16) |
						((*buffer_mem_line4)<<24);

				buffer_mem_line-=buffer_mem_offset4;
				buffer_mem_line2-=buffer_mem_offset4;
				buffer_mem_line3-=buffer_mem_offset4;
				buffer_mem_line4-=buffer_mem_offset4;
				*buffer_scr++= (*buffer_mem_line) |
						((*buffer_mem_line2)<<8) |
						((*buffer_mem_line3)<<16) |
						((*buffer_mem_line4)<<24);

				buffer_mem_line-=buffer_mem_offset4;
				buffer_mem_line2-=buffer_mem_offset4;
				buffer_mem_line3-=buffer_mem_offset4;
				buffer_mem_line4-=buffer_mem_offset4;
	/* New Code */
				y-=4;
			} while(y);
			buffer_scr+=buffer_scr_offset;
			x--;			
		} while(x);
	} /* non-stretched mode */
	else
	{ /* stretch mode on */
		do {
			/* 
			 *	The rotation code has been re-written from MAME GP32 v1.9
			 *	as compiling with gcc4.02 produces problematic results
			 *	Changes:
			 *	* Four buffer_mem_offset pointers instead of the one.
			 *	* Added a 4 line offset.
			 */
			buffer_mem_line=buffer_mem++;
			buffer_mem_line2=buffer_mem_line-buffer_mem_offset;
			buffer_mem_line3=buffer_mem_line2-buffer_mem_offset;
			buffer_mem_line4=buffer_mem_line3-buffer_mem_offset;
			y=gp32_width>>2;
			do {
				*buffer_scr++= (*buffer_mem_line) |
						((*buffer_mem_line2)<<8) |
						((*buffer_mem_line3)<<16) |
						((*buffer_mem_line4)<<24);

				buffer_mem_line-=buffer_mem_offset4;
				buffer_mem_line2-=buffer_mem_offset4;
				buffer_mem_line3-=buffer_mem_offset4;
				buffer_mem_line4-=buffer_mem_offset4;
				*buffer_scr++= (*buffer_mem_line) |
						((*buffer_mem_line2)<<8) |
						((*buffer_mem_line3)<<16) |
						((*buffer_mem_line4)<<24);

				buffer_mem_line-=buffer_mem_offset4;
				buffer_mem_line2-=buffer_mem_offset4;
				buffer_mem_line3-=buffer_mem_offset4;
				buffer_mem_line4-=buffer_mem_offset4;
				*buffer_scr++= (*buffer_mem_line) |
						((*buffer_mem_line2)<<8) |
						((*buffer_mem_line3)<<16) |
						((*buffer_mem_line4)<<24);

				buffer_mem_line-=buffer_mem_offset4;
				buffer_mem_line2-=buffer_mem_offset4;
				buffer_mem_line3-=buffer_mem_offset4;
				buffer_mem_line4-=buffer_mem_offset4;
				*buffer_scr++= (*buffer_mem_line) |
						((*buffer_mem_line2)<<8) |
						((*buffer_mem_line3)<<16) |
						((*buffer_mem_line4)<<24);

				buffer_mem_line-=buffer_mem_offset4;
				buffer_mem_line2-=buffer_mem_offset4;
				buffer_mem_line3-=buffer_mem_offset4;
				buffer_mem_line4-=buffer_mem_offset4;
				y-=4;
			} while(y);
			buffer_scr+=buffer_scr_offset;
			x--;			
		} while(x);
	} /* stretch mode on */
}	

/* Update Display: Old Gfx Core */
static __inline void update_display_old(void)
{
	unsigned char *buffer_scr;
	unsigned char *buffer_mem = scrbitmap->line[gp32_yoffset]+gp32_xoffset;
	int *buffer_mem_line;
	int buffer_mem_offset = (int)(scrbitmap->line[1] - scrbitmap->line[0]);
	int x,y=0,px,pxi,py;
	int counter_h;
	int counter_v;

	if(gp32_triple_buffer)
		buffer_scr=gpDraw[nflip].o_buffer;
	else
		/*buffer_scr=(int *)(gpPicture+gp32_yscreen+(240*gp32_xscreen));*/
		buffer_scr=(int *)(gpPicture);
		
	if (!gp32_rotate) {

		pxi=gp32_xscreen*240;
		py=239-gp32_yscreen;
		if (!stretch) {
			while (y < gp32_height) {
				buffer_mem_line=(int *)buffer_mem;
				buffer_mem+=buffer_mem_offset;
				x=0;
				px=pxi+py;
				while (x < gp32_width) {

					*(buffer_scr+px) = (unsigned char)*buffer_mem_line;	
					px+=240;

					*(buffer_scr+px) = (unsigned char)((*buffer_mem_line)>>8);	
					px+=240;

					*(buffer_scr+px) = (unsigned char)((*buffer_mem_line)>>16);	
					px+=240;

					*(buffer_scr+px) = (unsigned char)((*buffer_mem_line)>>24);	
					px+=240;

					buffer_mem_line++;

					*(buffer_scr+px) = (unsigned char)*buffer_mem_line;	
					px+=240;

					*(buffer_scr+px) = (unsigned char)((*buffer_mem_line)>>8);	
					px+=240;

					*(buffer_scr+px) = (unsigned char)((*buffer_mem_line)>>16);	
					px+=240;

					*(buffer_scr+px) = (unsigned char)((*buffer_mem_line)>>24);	
					px+=240;

					buffer_mem_line++;

					*(buffer_scr+px) = (unsigned char)*buffer_mem_line;	
					px+=240;

					*(buffer_scr+px) = (unsigned char)((*buffer_mem_line)>>8);	
					px+=240;

					*(buffer_scr+px) = (unsigned char)((*buffer_mem_line)>>16);	
					px+=240;

					*(buffer_scr+px) = (unsigned char)((*buffer_mem_line)>>24);	
					px+=240;

					buffer_mem_line++;

					*(buffer_scr+px) = (unsigned char)*buffer_mem_line;	
					px+=240;

					*(buffer_scr+px) = (unsigned char)((*buffer_mem_line)>>8);	
					px+=240;

					*(buffer_scr+px) = (unsigned char)((*buffer_mem_line)>>16);	
					px+=240;

					*(buffer_scr+px) = (unsigned char)((*buffer_mem_line)>>24);	
					px+=240;

					buffer_mem_line++;

					x+=16;

				}
				y++;
				py--;
			}
		} else { /* stretch=true */
			if (stretch==2) { /*stretch mix */
				counter_v=(old_counter & 1? 0:1);
				old_counter=counter_v;
			} else 
				counter_v=0; /*stretch skip */
			while (y < gp32_height) {
				if (stretch==2)
					counter_h=(y & 1? 0:1); /* stretch mix */
				else
					counter_h=0; /* stretch skip */

				if (!skip_h)
					counter_h++; /* do not skip horizontal lines if vertical stretch */

				buffer_mem_line=(int *)buffer_mem;
				buffer_mem+=buffer_mem_offset;
				x=0;
				px=pxi+py;
				while (x < gp32_width) {

					if (counter_h==skip_h) 
						counter_h=0;
					else {
						*(buffer_scr+px) = (unsigned char)*buffer_mem_line;
						px+=240;
						x++;
						counter_h++;
					}
					
					if (counter_h==skip_h) 
						counter_h=0;
					else {
						*(buffer_scr+px) = (unsigned char)((*buffer_mem_line)>>8);
						px+=240;
						x++;
						counter_h++;
					}
					
					if (counter_h==skip_h) 
						counter_h=0;
					else {
						*(buffer_scr+px) = (unsigned char)((*buffer_mem_line)>>16);
						px+=240;
						x++;
						counter_h++;
					}

					if (counter_h==skip_h) 
						counter_h=0;
					else {
						*(buffer_scr+px) = (unsigned char)((*buffer_mem_line)>>24);
						px+=240;
						x++;
						counter_h++;
					}

					buffer_mem_line++;

				}
				y++;
				if (skip_v) {
					counter_v++;
					if (counter_v==skip_v) {
						counter_v=0;
						buffer_mem+=buffer_mem_offset;
					} 
				}
				py--;
			}
		}
		
	} else {
		if (!stretch) {
			pxi=239-gp32_xscreen;
			py=(319-gp32_yscreen)*240;
			while (y < gp32_height) {
				buffer_mem_line=(int *)buffer_mem;
				buffer_mem+=buffer_mem_offset;
				x=0;
				px=pxi+py;
				while (x < gp32_width) {

					*(buffer_scr+px) = (unsigned char)*buffer_mem_line;	
					px--;

					*(buffer_scr+px) = (unsigned char)((*buffer_mem_line)>>8);	
					px--;

					*(buffer_scr+px) = (unsigned char)((*buffer_mem_line)>>16);	
					px--;

					*(buffer_scr+px) = (unsigned char)((*buffer_mem_line)>>24);	
					px--;

					buffer_mem_line++;

					*(buffer_scr+px) = (unsigned char)*buffer_mem_line;	
					px--;

					*(buffer_scr+px) = (unsigned char)((*buffer_mem_line)>>8);	
					px--;

					*(buffer_scr+px) = (unsigned char)((*buffer_mem_line)>>16);	
					px--;

					*(buffer_scr+px) = (unsigned char)((*buffer_mem_line)>>24);	
					px--;

					buffer_mem_line++;

					*(buffer_scr+px) = (unsigned char)*buffer_mem_line;	
					px--;

					*(buffer_scr+px) = (unsigned char)((*buffer_mem_line)>>8);	
					px--;

					*(buffer_scr+px) = (unsigned char)((*buffer_mem_line)>>16);	
					px--;

					*(buffer_scr+px) = (unsigned char)((*buffer_mem_line)>>24);	
					px--;

					buffer_mem_line++;

					*(buffer_scr+px) = (unsigned char)*buffer_mem_line;	
					px--;

					*(buffer_scr+px) = (unsigned char)((*buffer_mem_line)>>8);	
					px--;

					*(buffer_scr+px) = (unsigned char)((*buffer_mem_line)>>16);	
					px--;

					*(buffer_scr+px) = (unsigned char)((*buffer_mem_line)>>24);	
					px--;

					buffer_mem_line++;

					x+=16;

				}
				y++;
				py-=240;
				
			}
		}
				

		else	/* Old Core Rotated Stretched */
		{
                        if (stretch==2) { /*stretch mix */
                                counter_h=(old_counter & 1? 0:1);
                                old_counter=counter_h;
                        } else
                                counter_h=0; /*stretch skip */

			pxi=239-gp32_xscreen;
			py=(319-gp32_yscreen)*240;

			while (y < gp32_height) {
                                if (stretch==2)
                                        counter_v=(y & 1? 0:1); /* stretch mix */
                                else
                                        counter_v=0; /* stretch skip */

                                if (!skip_v)
                                        counter_v++; /* do not skip horizontal lines if vertical stretch */

				buffer_mem_line=(int *)buffer_mem;
				buffer_mem+=buffer_mem_offset;
				x=0;
				px=pxi+py;
				while (x < gp32_width) {

					if (counter_v==skip_v) 
						counter_v=0;
					else {
						*(buffer_scr+px) = (unsigned char)*buffer_mem_line;	
						px--;
						x++;
						counter_v++;
					}

					if (counter_v==skip_v) 
						counter_v=0;
					else {
						*(buffer_scr+px) = (unsigned char)((*buffer_mem_line)>>8);	
						px--;
						x++;
						counter_v++;
					}

					if (counter_v==skip_v) 
						counter_v=0;
					else {
						*(buffer_scr+px) = (unsigned char)((*buffer_mem_line)>>16);	
						px--;
						x++;
						counter_v++;
					}

					if (counter_v==skip_v) 
						counter_v=0;
					else {
						*(buffer_scr+px) = (unsigned char)((*buffer_mem_line)>>24);	
						px--;
						x++;
						counter_v++;
					}

					buffer_mem_line++;

					if (counter_v==skip_v) 
						counter_v=0;
					else {
						*(buffer_scr+px) = (unsigned char)*buffer_mem_line;	
						px--;
						x++;
						counter_v++;
					}

					if (counter_v==skip_v) 
						counter_v=0;
					else {
						*(buffer_scr+px) = (unsigned char)((*buffer_mem_line)>>8);	
						px--;
						x++;
						counter_v++;
					}

					if (counter_v==skip_v) 
						counter_v=0;
					else {
						*(buffer_scr+px) = (unsigned char)((*buffer_mem_line)>>16);	
						px--;
						x++;
						counter_v++;
					}

					if (counter_v==skip_v) 
						counter_v=0;
					else {
						*(buffer_scr+px) = (unsigned char)((*buffer_mem_line)>>24);	
						px--;
						x++;
						counter_v++;
					}

					buffer_mem_line++;

					if (counter_v==skip_v) 
						counter_v=0;
					else {
						*(buffer_scr+px) = (unsigned char)*buffer_mem_line;	
						px--;
						x++;
						counter_v++;
					}

					if (counter_v==skip_v) 
						counter_v=0;
					else {
						*(buffer_scr+px) = (unsigned char)((*buffer_mem_line)>>8);	
						px--;
						x++;
						counter_v++;
					}

					if (counter_v==skip_v) 
						counter_v=0;
					else {
						*(buffer_scr+px) = (unsigned char)((*buffer_mem_line)>>16);	
						px--;
						x++;
						counter_v++;
					}

					if (counter_v==skip_v) 
						counter_v=0;
					else {
						*(buffer_scr+px) = (unsigned char)((*buffer_mem_line)>>24);	
						px--;
						x++;
						counter_v++;
					}
					buffer_mem_line++;

					if (counter_v==skip_v) 
						counter_v=0;
					else {
						*(buffer_scr+px) = (unsigned char)*buffer_mem_line;	
						px--;
						x++;
						counter_v++;
					}

					if (counter_v==skip_v) 
						counter_v=0;
					else {
						*(buffer_scr+px) = (unsigned char)((*buffer_mem_line)>>8);	
						px--;
						x++;
						counter_v++;
					}

					if (counter_v==skip_v) 
						counter_v=0;
					else {
						*(buffer_scr+px) = (unsigned char)((*buffer_mem_line)>>16);	
						px--;
						x++;
						counter_v++;
					}

					if (counter_v==skip_v) 
						counter_v=0;
					else {
						*(buffer_scr+px) = (unsigned char)((*buffer_mem_line)>>24);	
						px--;
						x++;
						counter_v++;
					}
					buffer_mem_line++;

				}
				y++;
				if (skip_h) {
					counter_h++;
					if (counter_h==skip_h) {
						counter_h=0;
						py-=240;
						buffer_mem+=buffer_mem_offset;
					}
				}
			}
		}
	}
}

/* Update the display. */
void osd_update_display(void)
{
	/* Update Timing */
	update_timing();

	/* Manage the palette */
	if (dirtypalette)
		update_palette();

	/* copy the bitmap to screen memory */
	if (gp32_new_gfx_core) {
		if (gp32_rotate)
			update_display_rotated();
		else
			update_display();
	} else
		update_display_old(); /* Old Gfx Core */

#ifdef FPS_DISPLAY
	if (gp32_fps_display)
		frame_counter(); /* Show frame counter */
#endif	

	/* Flip Video Buffer */
	if (gp32_triple_buffer) {
	
		/* Flip Video Surface */
		GpSurfaceFlip( &gpDraw[nflip] );

		/* Change Video Buffer Number */
		nflip++;
		nflip&=3;
	}
}
